﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Net.Http;
using System.Net.Http.Headers;
using System.Diagnostics;
using Newtonsoft.Json.Linq;

namespace esl
{
    class SigningStatusREST
    {
        public static void main()
        {
            string packageId = "XB4m3cocNudSPEAoUDCIZgbkZD4=";
            string signerId1 = "Signer1";
            string signerId2 = "Singer2";

            HttpClient httpClient = new HttpClient();
            httpClient.DefaultRequestHeaders.Add("Authorization", "Basic " + Properties.Settings.Default.key);
            httpClient.DefaultRequestHeaders.Add("Accept", "application/json");

            //Get package status
            var response = httpClient.GetAsync(new Uri("https://sandbox.esignlive.com/api/packages/" + packageId + "/signingStatus")).Result;
            Debug.WriteLine(string.Format("Status of package: {0}", JObject.Parse(response.Content.ReadAsStringAsync().Result)["status"]));

            //Get signer status
            response = httpClient.GetAsync(new Uri("https://sandbox.esignlive.com/api/packages/" + packageId + "/signingStatus?signer=" + signerId1)).Result;
            Debug.WriteLine(string.Format("Status of signer 1: {0}", JObject.Parse(response.Content.ReadAsStringAsync().Result)["status"]));

            response = httpClient.GetAsync(new Uri("https://sandbox.esignlive.com/api/packages/" + packageId + "/signingStatus?signer=" + signerId2)).Result;
            Debug.WriteLine(string.Format("Status of signer 2: {0}", JObject.Parse(response.Content.ReadAsStringAsync().Result)["status"]));
        }
    }
}
